package ss2010.ng;

import robocode.*;
import java.awt.*;
import java.awt.geom.Point2D;
import java.io.IOException;

import robocode.util.*;



public class Nadeschda extends TeamRobot {
	
	//Variablen Deklaration
	boolean Vorwärts;
	int zähle=0;
	String name;
	String name2;
	
	
	//Standardverhalten
	public void run (){
		//Färben des Roboters
		setBodyColor(Color.blue); //Färbt den Unterbau blau
		setGunColor(Color.yellow); //färbt die Kanone gelb
		setRadarColor(Color.pink); //färbt das Radar pink
		
		// Turm und Radar sollen sich unabhängig von den untergeordneten Teilen drehen
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		
		// Maximale Geschwindigkeit
		setMaxVelocity(8);
		
		//Bewegungsmuster, wenn kein Ereignis eintritt
		do {
	        setAhead(100);
	        turnRadarRight(360);
	        setTurnLeft(180);
	        turnRadarLeft(360);
	        setBack(100);
	        turnRadarRight(360);
	    } while (true);		
	}
	
	//Verhalten, wenn ein anderer Roboter gescannt wird
	public void onScannedRobot(ScannedRobotEvent e){
		
		//Deklaration der Variablen
		name=e.getName(); // speichert den Namen des feindlichen Roboters
		double myX = getX(); //speichert die X-Koordinate, meines Roboters
		double myY = getY(); //speichert die Y-Koordinate, meines Roboters
		double headingRadians = getHeadingRadians(); //gibt die Position, bzw. die Richtung, in welche mein Roboter gedreht ist, in Radian zurück
		double EnemyBearingRadians = e.getBearingRadians(); //gibt den relativen Winkel des feindlichen Roboters zu meinem Roboter in Radian zurück
		double Distance = e.getDistance(); //gibt die Distanz bis zum feindlichen Roboter zurück
		double enemyHeading = e.getHeadingRadians(); //gibt die Kursrichtung des feindlichen Roboters in Radian an
		double enemyVelocity = e.getVelocity(); //gibt die Geschwindigkeit des feindlichen Roboters wieder
		
		//kleine Berechnungen, für das eigentliche Vorgehen
		double bulletPower = Math.min(3.0,getEnergy()); //je nach Energie wird gefeuert
		double absoluteBearing = headingRadians + EnemyBearingRadians; //gibt den absoluten Winkel an (in Radian)
		double enemyX = getX() + Distance * Math.sin(absoluteBearing); //Berechnun der X-Koordinate des feindlichen Roboters
		double enemyY = getY() + Distance * Math.cos(absoluteBearing); //Berechnung der Y-Koordinate des feindlichen Roboters
		System.out.println(headingRadians+" headingRadians");
		System.out.println(EnemyBearingRadians+"  EnemyBearingRadians");
		System.out.println(absoluteBearing+"  absoluteBearing");
		System.out.println(Math.sin(absoluteBearing)+"  sinabsoluteBearing");
		System.out.println(Distance+ "  Distanz");
		System.out.println(getX()+"  myX");
		System.out.println(enemyX+" enemyX");
		System.out.println(Distance*Math.sin(absoluteBearing)+"  delta x");
	
		//Teampartner sollen sich nicht absichtlich gegenseitig beschießen
		if(isTeammate(e.getName())){
			return;}
		
		
		//Bewegungsmethode unseres Roboters, während eines Angriffs --> Oszillator Movement
		movementOszillator(200, EnemyBearingRadians, Distance);

		//Zielvorgang unseres Roboters --> Lineares Targeting
		double deltaTime = 0; //setzt den Zeitpunkt auf null
		double battleFieldHeight = getBattleFieldHeight(), //gibt die Höhe des Spielfeldes zurück
		       battleFieldWidth = getBattleFieldWidth(); //gibt die Weite des Spielfeldes zurück
		double predictedX = enemyX, predictedY = enemyY; //übergibt die Koordinaten des Feindes
		while((++deltaTime) * (20.0 - 3.0 * bulletPower) < //strecke, die die Kugel zurücklegen würde, bzw. der Punkt an dem die kugel sich nach der zeit befindet
					//20.0-3.0*bulletPower == Geschwindigkeit der Kugel
					//Funktion von Java, um die Entfernung zwischen zwei Punkten zu ermitteln
			      Point2D.Double.distance(myX, myY, predictedX, predictedY)){	//Entfernung der Koordinaten von unserem Roboter zu den Koordianten zum Feind	
				predictedX += Math.sin(enemyHeading) * enemyVelocity;	//die Koordinaten des feindlichen Roboters verändern sich je nach Geschwindigkeit 
				predictedY += Math.cos(enemyHeading) * enemyVelocity; //Berechnung der veränderten Koordinaten nach jeder Zeiteinheit
				//Da der feindliche Roboter an der Wand wahrscheinlich seine Richtung ändern wird, wird dies in der Berechnung berücksichtigt
				if(	predictedX < 18.0 
					|| predictedY < 18.0
					|| predictedX > battleFieldWidth - 18.0
					|| predictedY > battleFieldHeight - 18.0){
					//Die Koordinaten des feindlichen Roboters sollen in der Berechnung eine Grenze von 18 bis zu den Wänden nicht überschreiten
					predictedX = Math.min(Math.max(18.0, predictedX), 
			                    battleFieldWidth - 18.0);	
					predictedY = Math.min(Math.max(18.0, predictedY), 
			                    battleFieldHeight - 18.0);
					break;
				}
			}
		
			
			//Die Koordinaten werden zuerst an die Atanfunktion übergeben, welche den Winkel berechnet und anschließden an die Utils..., welche die Bewegung des Roboters verkürzt
			double theta = Utils.normalAbsoluteAngle(Math.atan2(//atan2 berechnet den winkel zwischen der linie, die vom ursprung bis zum Punkt x,y führt und der x-achse
			    predictedX - getX(), predictedY - getY())); //meine Koordinaten werden abgezogen, da sich der winkel vom ursprung aus bezieht, ich aber meinen winkel haben möchte
				
			
			//Nun soll der Radar auf den feindlichen und anvisierten Roboter gerichtet werden
			setTurnRadarRightRadians(
			    Utils.normalRelativeAngle(absoluteBearing - getRadarHeadingRadians())); //drehe den Radar so, dass es die position des absolute Bearings einnimmt --> deswegen minus die gradzahl des radars, denn um so viel grad muss es sich noch drehen
			//anschließend die Kanone
			setTurnGunRightRadians(Utils.normalRelativeAngle(theta - getGunHeadingRadians()));//ebenso
			//und dann:
			fire(bulletPower);}//Feuer frei!!
						
		
	
	
	
	//Stößt unser Roboter mit einem anderen zusammen, so soll er sich in die entgegengesetzte Richtung bewegen
	public void onHitRobot(HitRobotEvent e){
		if (e.isMyFault()){
			Richtungswechsel();
		}
	}
	//Stößt unser Roboter an die Wand, so soll er sich in die entgegengesetzte Richtung bewegen
	public void onHitWall(HitWallEvent e){
		Richtungswechsel();
	}
	
	//Wenn er fünfmal daneben schießt, so soll er sein Teammitglied um Hilfe rufen und den Namen des feindlichen Roboters übergeben
	public void onBulletMissed(BulletMissedEvent event){
		if(name==name2){ 
			zähle++;
			if(zähle==5){
				try {
					broadcastMessage(name);
					zähle=0;
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		}
		else{
			zähle=0;
			name2=name;
		}
	}
	
	
	//Bewegungsmethode --> Richtungswechsel
	public void Richtungswechsel(){
		if(Vorwärts){
			setBack(400);
			Vorwärts=false;
		}
		else{
			setAhead(400);
			Vorwärts=true;
		}
	}
	
	//Bewegungsmethode --> Oszillator Movement
	public void movementOszillator(int n, double EnemyBearingRadians, double Distance){
		int a=12;
		int b = 7;
			
if (getDistanceRemaining() == 0) {setAhead(n * Math.sin(getTime() / a) * Math.cos(getTime() / b)); } //Steht unser Roboter still, so soll er wieder in Bewegung gesetzt werden, a und b geben dabei die Frequenz an
			setTurnRightRadians(EnemyBearingRadians + Math.PI/2 - 0.5236 * (Distance > n ? 1 : -1)); //Unterschreitet er eine freit wählbare Distanz zum feindlichen Roboter, so soll er die Distanz vergrößern
	}
	
}



