package ss2010.ClevernSmart;
import robocode.util.Utils;
import robocode.*;
import java.awt.Color;


public class Jeff_Smart extends TeamRobot { // TR1 erbt die Eigenschaften von TeamRobot
	
	//Unterschiedliche Debugstufen
	boolean debugGes = false;  //Sendet alle gewünschten Infos
	boolean debugFunktionen = false; //Sendet nur die aktuelle Funktion
	boolean debugBewegung = false; // Sendet nur Bewegungsinfos
	boolean debugWaffen = false;  //Sendet nur Waffeninfos
	boolean debugRadar = false;   //Sendet nur Radarinfos
	
	boolean start = true; // Variable für Startsequenz
	
	int durchlauf = 0; //Anzahl Scandurchläufe
	int durchlaufstart =0; //Anzahl der Abgegebenen Schüsse in die Mitte
	
	public void run(){
		if (debugGes||debugFunktionen) out.println("--Run--");
		
		//Der Robo kommt seinem Vorbild Jeff Smart sehr ähnlich :-)
		setBodyColor(Color.RED);
		setGunColor(Color.WHITE);
		setRadarColor(Color.BLACK);
		setBulletColor(Color.LIGHT_GRAY);
		
		setMaxVelocity(8); //Maximale Geschwindigkeit für Bewegunngen
		
		//Alle noch offenen Aktionen beenden, damit es bei 0 losgeht.
		clearAllEvents();
		
		/* Startsequenz
		 * Es sollen insgesamt 8 Schüsse in die Mitte abgefeuert werden
		 */
		if(start){
			// Streung der Schüsse in die Mitte
			int streuen =10;
			
			if (debugGes||debugFunktionen) out.println("--Run - if(start)--");
			while(start && durchlaufstart<8){
				if (debugGes||debugFunktionen) out.println("--Run - while(start)--");
				zurMitte(); //zur Mitte hin ausrichten
				while(getGunHeat()>0){
					if (debugGes||debugFunktionen) out.println("--Run - doNothing()--");
					doNothing();
				}
				if (debugGes||debugFunktionen) out.println("--Run - while(start) Wert durchlaufstart: "+durchlaufstart);
				
				//Schüsse sollen gestreut werden um trefferchancen zu erhöhen
				streuen =-streuen;
				turnGunRight(streuen);
				durchlaufstart++;
				fire(1.5);
			}
			start = false;
		}	
		
		//while(true) Wird immer dann ausgeführt, wenn keine Events passieren.		
		while(true){
			if (debugGes||debugFunktionen) out.println("--Run - while(true)--");
			turnGunRight(2.5);
		}
	}
	
	//Event wird ausgelöst, wenn Jeff gegen die Wand fährt
	public void onHitWall(HitWallEvent e){
		if (debugGes||debugFunktionen) out.println("--onHitWall--");
		//Vorderer Bereich angeschlagen
		if(e.getBearing()>=-90&&e.getBearing()<=90){ 
			back(100);
			turnRight(180);
		}
		//Hinterer Bereich angeschlagen 
	   	else ahead(100);
	} 
	
	//Event wird ausgelöst, wenn Jeff gegen die Wand fährt
	public void onHitRobot(HitRobotEvent e){
		
		if ((isTeammate(e.getName()))||(e.getName().equals("Jeff_Smart"))||(e.getName().equals("Jeff_Smart1.0"))||(e.getName().equals("Jeff_Smart*")))
						{return;}  
		
    	if (debugGes||debugFunktionen) out.println("--onHitRobot--");
    	//Kollision im vorderen Bereich
    	if(e.getBearing()>=-90 && e.getBearing()<=90){ 
			back(30);
			fire(1);			
		}
    	//Kolision im hinteren Bereich
    	else{
    		ahead(30);
			turnRight(180);
			fire(2);
		}  	
    }

	//Aktionen wenn ein Roboter gescannt wurde
    public void onScannedRobot(ScannedRobotEvent e) {
    	if (debugGes||debugFunktionen) out.println("--onScannedRobot--");
    	if (debugGes||debugRadar) out.println("Robo " + e.getName() + " gefunden");
    	
    	if ((isTeammate(e.getName()))||(e.getName().equals("Jeff_Smart"))||(e.getName().equals("Jeff_Smart1.0"))||(e.getName().equals("Jeff_Smart*")))
						{return;}  

		double entfernung = e.getDistance();
    	
    	if(start)return; //Abbruch während der Startphase
    	    	
    	//Kampfverhalten, bei mehr als 4 verbleibenden Robotern
    	if(getOthers()>4){
    		//Kampfverhalten bei einem Energielevel > 40
    		if(getEnergy()>40){
    			if (debugGes||debugFunktionen) out.println("getOthers()>4;\ngetEnergy>40");
    			
    			//Aufteilung der Kampfzonen
    			if(entfernung <=150){
    				if (debugGes||debugFunktionen) out.println("Entfernung: "+ entfernung +" --> Zielzone 2");
    				durchlauf = 0;
    				track(3,e);
    			}
    			else if(entfernung <=300){
    				if (debugGes||debugFunktionen) out.println("Entfernung: "+ entfernung +" --> Zielzone 3");
    				durchlauf = 0;
    				track(2,e);
    			}
    			else if (entfernung > 300){
    				if (debugGes||debugFunktionen) out.println("Entfernung: "+ entfernung +" --> Zielzone 4");
    				if(durchlauf > getOthers()){
    					durchlauf = 0;
    					anschleichen(entfernung);
    				}
    				else{
    					durchlauf++;
    					return;
    				}
    			}
    		}
    		
    		//Kampfverhalten bei einem Energielevel <= 40 (etwas defensiver)
    		else{
    			if (debugGes||debugFunktionen) out.println("getOthers()>4;\ngetEnergy<=40");
    			
    			//Aufteilung der Kampfzonen
    			if(entfernung<=50){
    				if (debugGes||debugFunktionen) out.println("Entfernung: "+ entfernung +" --> Zielzone 1");
    				durchlauf = 0;
    				track(3,e);
    			}
    			else if(entfernung <=150){
    				if (debugGes||debugFunktionen) out.println("Entfernung: "+ entfernung +" --> Zielzone 2");
    				durchlauf = 0;
    				track(2.5,e);
    			}
    			else if(entfernung <=200){
    				if (debugGes||debugFunktionen) out.println("Entfernung: "+ entfernung +" --> Zielzone 3");
    				durchlauf = 0;
    				track(1.5,e);
    			}
    			else if (entfernung <= 300){
    				if (debugGes||debugFunktionen) out.println("Entfernung: "+ entfernung +" --> Zielzone 4");
    				durchlauf ++;
    				fire(1);
    				if(durchlauf > getOthers()){
    					durchlauf = 0;
    					anschleichen(entfernung);
    				}
    			}
    			else if (entfernung > 300){
    				if (debugGes||debugFunktionen) out.println("Entfernung: "+ entfernung +" --> Zielzone 5");
    				if(durchlauf > getOthers()){
    					durchlauf = 0;
    					anschleichen(entfernung);
    				}
    				else{
    					durchlauf++;
    					return;
    				}
    			}
    			    				
    		}
    	}
    	//Kampfverhalten bei 4 oder weniger Robotern
    	else{
    		if(entfernung<=150){
				if (debugGes||debugFunktionen) out.println("Entfernung: "+ entfernung +" --> Zielzone 1");
				durchlauf = 0;
				track(3,e);
			}
			else if(entfernung <=200){
				if (debugGes||debugFunktionen) out.println("Entfernung: "+ entfernung +" --> Zielzone 2");
				durchlauf = 0;
				track(2,e);
			}
			else if (entfernung <= 300){
				if (debugGes||debugFunktionen) out.println("Entfernung: "+ entfernung +" --> Zielzone 3");
				durchlauf ++;
				fire(1);	
				if(durchlauf >= getOthers()){
					durchlauf = 0;
					anschleichen(entfernung);
				}
			}
			else{
				if (debugGes||debugFunktionen) out.println("Entfernung: "+ entfernung +" --> Zielzone 4");
	
				durchlauf ++;
				if(durchlauf >= getOthers()){
					durchlauf = 0;
					anschleichen(entfernung);
				}
			}
				
		}
			
    }
   
    //Aktionen wenn Roboter von einer Kugel getroffen wurde
   public void onHitByBullet(HitByBulletEvent e){
    	if (debugGes||debugFunktionen) out.println("--onHitByBullet--");
    	bewegen();
    }
   
    //In dieser Funktion sind die Bewegungsmuster definiert
    public void bewegen (){
		//Neue 	Bewegungsfunktion soll nur noch über Standartmanöver verfügen, die in 
		//zufälliger Reihenfolge gewählt werden.
		if (debugGes||debugFunktionen) out.println("--Bewegen--");
		
		int zufall = (int) (Math.random()*7); //Zufallszahl wählt die Bewegung aus
		if (debugGes||debugBewegung) out.println("-Bewegung-\n Zufallszahl: "+zufall);
				
		switch(zufall){
			case(0):
				setTurnLeft(100);
				ahead(200);
				break;
			case(1):
				setTurnRight(100);
				ahead(200);
				break;
			case(2):
				setTurnLeft(100);
				back(200);
				break;
			case(3):
				setTurnRight(100);
				back(200);
				break;
			case(4):
				setAhead(100);
				break;
			case(5):
				setBack(100);
				break;
			default:
				stop();
				break;
		}
		execute();
	}
    
    //Funktion um sich dem Gegner indirekt zu nähren
    public void anschleichen(double dist){
    	if (debugGes||debugFunktionen) out.println("--Anschleichen--");
    	double drehung;
		
		/*
		 * turnGun erwartet wert in Grad. Daher muss das Heading in Grad umgerechnet werden.			 * 
		 * Umrechnung Bogenmaßzu Grad:
		 * Bogenmaß*180/Pi
		 */
		    	
		//Ausrichtung des Panzers auf das Ziel
		drehung = ((getHeadingRadians()*180/Math.PI)-getGunHeading());
		if(drehung>180)turnRight(360-drehung);
		else turnLeft(drehung);
					
		//Ausrichtung der Gun nach vorne
		drehung = (getHeadingRadians()*180/Math.PI) - getGunHeading();
		if(drehung>180)turnGunLeft(360-drehung);
		else turnGunRight(drehung);    	
    	
		
    	
    	double weg = Math.sqrt((dist*dist)/2); //Berechnung der zu fahenden Strecke (Pytagoras)
    	clearAllEvents();
		turnRight(45);
		ahead(weg);
		turnLeft(90);

	}
	//Funktion die den Robo abhänging von seiner Position zur mitte hinn ausrichtet.
    public void zurMitte(){
    	if (debugGes||debugFunktionen) out.println("--ZurMitte--");
    	
		double x,y,xMax,yMax,drehung ;
		x = getX();
		y = getY();
		xMax = getBattleFieldWidth();
		yMax = getBattleFieldHeight();
						
		//Linke Hälfte 
		if(x<xMax*0.5){ 
			//unten
			if(y<yMax*0.5){
				drehung = getHeading()- 45;
				if(drehung>225 && drehung<45)turnRight(-drehung);
				else turnLeft(drehung);
			}
			//oben
			else{
				drehung = getHeading()- 135;
				if(drehung>315 && drehung<135)turnRight(-drehung);
				else turnLeft(drehung);			
			}
		}
		//Rechte Hälfte
		else {
			//unten
			if(y<yMax*0.5){
				drehung = getHeading()- 315;
				if(drehung>135 && drehung<315)turnRight(-drehung);
				else turnLeft(drehung);			
			}
			//oben
			else{
				drehung = getHeading()- 225;
				if(drehung>45 && drehung<225)turnRight(-drehung);
				else turnLeft(drehung);				
			}
		}
	}
    
    //Abgewandelter NarrowLock 
    public void track(double staerke, ScannedRobotEvent e){
    	if (debugGes||debugFunktionen) out.println("--Funktion Track--");
		if (debugGes||debugWaffen){
			out.println("---Schuss Setup---");
			out.println("Eigne Energie: " + getEnergy()); 
			out.println("Anzahl Roboter: " + getOthers());
			out.println("Schusstärke: " + staerke); 
			out.println("GunHeat: " + getGunHeat());
		}
		
    	double absoluteBearing = getHeadingRadians() + e.getBearingRadians();
    	setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(absoluteBearing - getGunHeadingRadians()));
        fire(staerke);
    }
    
    public void onDeath(DeathEvent event){
	    System.out.println("Wartet's ab, ich komme wieder");	        
    }
    
    public void onWin(WinEvent event){
	    System.out.println("Wir brauchen Gegner, keine Opfer :-)");
    	   setBodyColor(Color.white);
           setGunColor(Color.lightGray);
           setRadarColor(Color.white);
    }	
    
}


