// Team SearchandDestroy
package ss2007.Team4;
import robocode.*;
import java.awt.Color;
import java.io.*;

/**
 * Schlagges - a robot by (Boris Backes)
 */
public class Schlagges extends TeamRobot
{
	
	double gunTargetAngle = 0;
	double bulletTargetSpeed = 0;
	double gunCorrectAngle = 0;
	double gunTurnAmount = 10;
	double radarTurnAmount = 12;
	int count = 0;
	double direction = 50;  // Direction of moving
	double toFar = 200; 	// Maximim distance
	double toClose = 100; 	// Minimum distance 
	String newTarget;		// Target given by Teammate
	String name2;
	double correctWay = 45; // Prevent moving straight to a robot
	
		
		// run: that is the normal behavior method
	
		public void run() {
		setAllColors(new Color (0,0,0));
		setBulletColor(new Color(0,255,255));
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		
			while(true) {
				// loop forever
				turnRadarRight(100);
				
				
		}
	}



	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		out.println(direction);
		if (isTeammate(e.getName())) {return;}														// Prevent friendly fire
		if (newTarget != null){																		// If a target name is given
			if (!newTarget.equals(e.getName())) {return;}											// Scan until found him ... 
		}						 
		radarTurnAmount = normalRelativeAngle(e.getBearing() + (getHeading()-getRadarHeading())); 	// Radar face to target
		setTurnRadarRight(radarTurnAmount); 														// Radar faced exactly to target
		gunTurnAmount = normalRelativeAngle(getRadarHeading()-getGunHeading());						// Gun face to target
		gunTargetAngle = normalRelativeAngle(180-(e.getHeading()-getGunHeading()))  ;				// Angle between and target movement
		bulletTargetSpeed = (Math.abs(e.getVelocity()) / Rules.getBulletSpeed(firePower(Math.abs(e.getVelocity()),e.getVelocity())));	// Compare bullet speed to target speed
		setScanColor(new Color(Math.abs(255-(int)(e.getDistance()*(255/getBattleFieldHeight()))),0,0));
		setRadarColor(new Color(255,0,0));
	
		// Now the prophecy for gun correction
		gunCorrectAngle = Math.toDegrees(Math.asin (Math.toRadians((bulletTargetSpeed) * Math.toDegrees(Math.sin(Math.toRadians(gunTargetAngle))))));
		if (e.getVelocity() > 0 ) {gunTurnAmount+=gunCorrectAngle;}
		if (e.getVelocity() < 0 ) {gunTurnAmount-=gunCorrectAngle;}
		
		setTurnGunRight(gunTurnAmount); 	// Now the gun has correct angle
		
		// Move towards target
		if (e.getDistance() > toFar){
			if (gunTargetAngle <  0){setTurnRight(e.getBearing()-correctWay);}
			if (gunTargetAngle >= 0){setTurnRight(e.getBearing()+correctWay);}
			moveRobot(50);
		}
		
		// Circle around the target
		if (e.getDistance() > toClose && e.getDistance() <= toFar){
			setTurnRight(e.getBearing() + 90);
			moveRobot(direction);
			
			
		}
		// To close to target, get away
		if (e.getDistance() < toClose) {
				setBack(direction);
			
		}	

		//Only one? Lesser Energy? - Go Ramming
		if (e.getEnergy()<getEnergy() && getOthers() == 1){
			setBodyColor(new Color(255,0,0));
			toFar=10;
			toClose=0;
			correctWay=0;
		}else  {
			setBodyColor(new Color(0,0,0));
			toFar = 200;
			toClose = 100;
			correctWay=45;
		}
		
		
		setFire(firePower(Math.abs(e.getVelocity()), e.getDistance()));
		scan();
	}

	// What to do when hit by a bullet	
	public void onHitByBullet(HitByBulletEvent e) {
		String name = e.getName();							// Get name of the attacking robot
		if(name==name2){									// Did he hit me again?
			count++;										// Count his bad behavior
			if(count ==3){                               	// If hit 3 times by the same robot	...
				try{broadcastMessage(new Message(name)); 	// ... send his name to all teammates
				out.println("Brauche Hilfe!");
				count=0;
				}
				catch (IOException Ex){}					// Catch the exception if sending failed
			}
		}
		else{												// Hit by another bot? Restart counting.
			count=0;
			name2=name;
		}
		setTurnRight((e.getBearing()+90));						
		moveRobot(direction);
	}

	// What to do when crash into another tank
	public void onHitRobot(HitRobotEvent e) {
		if(e.getBearing()>-90 && e.getBearing()<90){
			direction = -direction;
			setBack(Math.abs(direction));
		}else {moveRobot(Math.abs(direction));}
	}
	
	// What to do when hit a Wall
	public void onHitWall(HitWallEvent e){
		direction = -direction;	
		moveRobot(direction);
	}
	
	public void moveRobot(double speed){
		setAhead(speed);
		
	}

	// Set fire power
	public double firePower(double targetSpeed, double targetDistance){
		if(targetDistance<100) {return 3;}    //fire powerfull at close tanks
		else {return (4 - (targetSpeed *3/8));} //fire powerfull at slow tanks
	}

	// We have won the round - let's dance !!!
	public void onWin(WinEvent e){
		setAllColors(new Color(255,255,255));
		for (int i=0;i <= 255; i++) {
			setBodyColor(new Color(i,0,0));
			turnLeft(360);
			setTurnRadarRight(360);
			}
		
	}

	// If teammate contact us, set new target to the teammate attacking bot
	public void onMessageReceived(MessageEvent e){
		Message p = (Message) e.getMessage();
		newTarget = (p.getTargetName());
		out.println("Neues Ziel: " + newTarget);
	}

	public void onRobotDeath(RobotDeathEvent e){
		if (newTarget != null){
			if (newTarget.equals(e.getName())){newTarget=null;}
		} out.println(e.getName() +" is R.I.P");
	}


	/**
	 * normalRelativeAngle:  Returns angle such that -180 < angle <= 180
	 */	
		
	public double normalRelativeAngle(double angle) {
		if (angle > -180 && angle <= 180) {
			return angle;
		}
		double fixedAngle = angle;

		while (fixedAngle <= -180) {
			fixedAngle += 360;
		}
		while (fixedAngle > 180) {
			fixedAngle -= 360;
		}
		return fixedAngle;
	}	
	
	
}
			
