/*
 * WPF ROBOCODE
 * Fachhochschule Kaiserslautern Standort Zweibrcken
 * Christian Reichert, Markus Bosslet, Andreas Wolf - COPYRIGHT 2007 
 *
 * ROBOT 1 -HACKE- by Andreas Wolf
 */
package ws2006.Team4;
import robocode.*;
import java.awt.Color;
import java.io.*;

public class Hacke extends TeamRobot
	{
	
	// Deklarieren und initialisieren aller spielrelevanten Konstanten

	// int Speed, gibt die Geschwindigkeit des Roboters an	
	final static int Speed = 150;

	// boolean debug, gibt an, ob man sich im Debug Modus befindet.
	// Sollte dies der Fall sein, werden verschiedene Statusmeldungen auf
	// der Standardausgabe ausgegeben
	final static boolean debug = false;
	
	// int ScanGeschwindigkeit, gibt die Geschwindigkeit der Drehung der Kanone inkl. Radar an
	final static int ScanGeschwindigkeit = 20;
	
	// double WandAbstand, gibt den Abstand zur Wand an, an der der Robot entlang fhrt
	final static double WandAbstand = 50;

	// Deklarieren und initialisieren aller spielrelevanten Variablen
	
	// double BattleFieldWidth, enthlt die Spielfeldbreite
	double BattleFieldWidth = 0;
	
	// double BattleFieldHeight, enthlt die Spielfeldhhe
	double BattleFieldHeight = 0;
	
	// double xPosition, enthlt die aktuelle, horizontale Position des Robots
	double xPosition = 0;
	
	// double yPosition, enthlt die aktuelle, vertikale Position des Robots
	double yPosition = 0;
	
	// boolean FirstRun, gibt an, ob der Bewegungsablauf sich im ersten Durchlauf befindet
	boolean FirstRun = true;
	
	/********************************************************************
	 * public void run()
	 *
	 * Aufruf bei Spielstart
	 *********************************************************************/
	public void run()
	{
		// Farben des gesamten Roboters setzen
		setColors(Color.magenta,Color.magenta,Color.magenta);

		// Geschwindigkeit des Roboters angeben, 8 = MAX
		setMaxVelocity(8);
		
		// bei Spielbeginn nach vorne an eine Wand fahren
		setAhead(500000);
		execute();
		
		// Hhe und Breite des Spielfeldes auslesen
		BattleFieldHeight = getBattleFieldHeight();
		BattleFieldWidth = getBattleFieldWidth();
		
		// Debug Meldung
		if(debug)
			System.out.println("BattleFieldHeight=" + BattleFieldHeight + " BattleFieldWidth=" + BattleFieldWidth);
	
		
		while(true) 
		{
			// Bewegung nach vorne
			setAhead(Speed);
			
			// Bewegung der Kanone inkl. Radar nach links
			setTurnGunLeft(ScanGeschwindigkeit);
			
			execute();
			
			if(FirstRun)
			{
				// im ersten Durchlauf nichts tun, da der Roboter
				// noch nicht an der Wand steht
				FirstRun = false;
			}
			else
			{
				// aktuelle horizontale und vertikale Position auslesen
				xPosition = getX();
				yPosition = getY();
			
				// verhindern, dass an die Wand gefahren wird
				if	(xPosition < WandAbstand && yPosition > BattleFieldHeight - WandAbstand) 
				{
					// obere linke Ecke
					stop();
					turnLeft(90);
					resume();
					
					// Debug Meldung
					if(debug)
						System.out.println("oben links " + getHeading());
					
					// weiterfahren, sodass keine potentielle Kollision gesehen wird
					ahead(WandAbstand + 3);
				}
				if	(xPosition < WandAbstand && yPosition < WandAbstand) 
				{
					// untere linke Ecke
					stop();
					turnLeft(90);
					resume();
					
					// Debug Meldung
					if(debug)
						System.out.println("unten links " + getHeading());
					
					// weiterfahren, sodass keine potentielle Kollision gesehen wird
					ahead(WandAbstand + 3);
				}
				if	(xPosition > BattleFieldWidth - WandAbstand && yPosition < WandAbstand) 
				{
					// untere rechte Ecke
					stop();
					turnLeft(90);
					resume();
					
					// Debug Meldung
					if(debug)
						System.out.println("unten rechts " + getHeading());	
					
					// weiterfahren, sodass keine potentielle Kollision gesehen wird
					ahead(WandAbstand + 3);
				}
				if	(xPosition > BattleFieldWidth - WandAbstand && yPosition > BattleFieldHeight - WandAbstand) 
				{
					// obere rechte Ecke
					stop();
					turnLeft(90);
					resume();
					
					// Debug Meldung
					if(debug)
						System.out.println("oben rechts " + getHeading());	
					
					// weiterfahren, sodass keine potentielle Kollision gesehen wird
					ahead(WandAbstand + 3);
				}
			}
		}
	}

	/********************************************************************
	 * public void onScannedRobot(ScannedRobotEvent e)
	 *
	 * Aufruf, sobal Robot gescannt wurde
	 *********************************************************************/
	public void onScannedRobot(ScannedRobotEvent e) 
	{
		// double maxDistance, enthlt den Abstand, bis zu dem geschossen wird,
		// wenn nur noch ein Robot auf dem Feld ist
		double maxDistance;
		
		// berprfen, ob der gescannte Robot ein Teammitglied ist
		if(!isTeammate(e.getName()))
		{
			// berechnen der maximalen Schussdistanz
			if(BattleFieldHeight < BattleFieldWidth)
				maxDistance = BattleFieldWidth / 2;
			else
				maxDistance = BattleFieldHeight / 2;
			
			// berprfen, ob nur noch ein Robot auf dem Spielfeld ist	
			if(getOthers() <= 1)
			{
				// wenn nur noch ein Robot auf dem Spielfeld ist, wird nur geschossen, wenn der 
				// Abstand zu dem gescannten Robot weniger als "maxDistance" plus eine Toleranz von 10 ist
				if(e.getDistance() <= maxDistance + 10)
				{
					// feuern mit 2
					fire(2);
					
					// Farben ndern, damit uerlich erkennbar ist, dass die Situation erkannt wurde
					setColors(Color.green,Color.green,Color.green);
				}
					
			}
			else
			{
				// Fallunterscheidung bei verschiedenen Distanzen
				
				if(e.getDistance() < 100)
				{
					// Distanz kleiner als 100, dann feuern mit 3
					fire(3);
				}
				else if(e.getDistance() < 200 && e.getDistance() >= 100)
				{
					// Distanz kleiner als 200 und grer, gleich 100, dann feuern mit 2
					fire(2);
				}
				else
				{
					// Distanz grer, gleich 200, dann feuern mit 1
					fire(1);
				}
			}
		}
		else
		{
			
			// sollte Teammitglied nher als 150 sein, dann Nachricht versenden, 
			// dass eine verhersehbare Kollision erkannt wurde, und zurck fahren
			if(e.getDistance() < 150)
			{
				// Nachricht versenden
				try {
					sendMessage("drei_promill.Hacke", "Kollision");
					} catch (IOException ex) {/* keine Fehlerbehandlung*/}
				
				// zurck fahren
				back(150);	
			}
		}
	}

	/********************************************************************
	 * public void onHitWall(HitWallEvent event) 
	 *
	 * Aufruf bei Wandberhrung
	 *********************************************************************/
	public void onHitWall(HitWallEvent event) 
	{
		// bei Wandberhrung 90 nach links drehen
		turnRight(event.getBearing() - 90);
   	}
	
	/********************************************************************
	 * public void onHitRobot(HitRobotEvent e) 
	 *
	 * Aufruf bei Zusammensta mit anderem Roboter
	 *********************************************************************/
	public void onHitRobot(HitRobotEvent e)	
	{
		if(!isTeammate(e.getName()))
		{
			// Kollision mit fremde Robot
			
			// nachschauen, ob die Kollision von vorne oder von hinten kam
			if (e.getBearing() > -90 && e.getBearing() < 90) 
			{
				// Kollision von vorne, dann weiche nach hinten aus
				setBack(100);
			}
			else 
			{
				// Kollision von hintern, dann weiche nach vorne aus
				setAhead(100);
			}
	
			execute();
		}
		else
		{
			// kollision mit Teammitglied
			
			// weiche nach hinten aus
			back(150);	
		}
		scan();
	}

	/********************************************************************
	 * public void onMessageReceived(MessageEvent event) 
	 *
	 * Aufruf beim Erhalt einer Nachricht
	 *********************************************************************/
	public void onMessageReceived(MessageEvent event)
	{
		// Debug Meldung
		if(debug)
			System.out.println("erhaltene Nachricht: " + event.getMessage());
					
		// bei Kollisions-Warnung von Teammitglied, zurck fahren
		if(event.getMessage().equals("Kollision"))		
		{
			// Debug Meldung
			if(debug)
				System.out.println(event.getMessage() + "erkannt");
			
			// um bevorstehende Kollision zu vermeiden, nach hinten ausweichen
			back(150);
		}
	}

	/********************************************************************
	 * public void onWin(WinEvent e)
	 *
	 * Aufruf bei Sieg
	 *********************************************************************/
	public void onWin(WinEvent e)
	{
		// Siegestanz
		while(true) 
		{
			turnLeft(50);
			turnRight(50);
		}
	}
}
