package ws2006.Team2;

/**
 * @author Thorsten Stadtfeld
 * @author Steffen Steinbrecher
 * @author Jzef Fehr
 * @author Stefan Reitz
 * 
 * created 2007-02-12 - 2007-02-16
 */

import robocode.*;

	/**
	 * The class EnemyBot extends the TeamRobot class and implements the datatype serializable.
	 * The class contains information on enemys of the robot team and helps to
	 * exchange the data on these ones.
	 */
	public class EnemyBot extends TeamRobot implements java.io.Serializable 
	{

		// information on the enemy
		private String name;
		private double bearing;
		private double bearingRadians;
		private double distance;
		private double energy;
		private double heading;
		private double velocity;
		private double firePower;
		private double X;
		private double Y;
		private String message;
		
		// Method mendatory for type serializable
		public int compareTo(java.lang.Object x) { return 0;}
		
		
		// Constructor
		public EnemyBot()
		{
			// reset enemy information
			this.reset();
		}
	
		
		/**
		 * getMessage: builds the message to send by broadcast message
		 * @param  
		 * @return String message
		 */	
		public String getMessage() {
		
			return(this.name+"#"+String.valueOf(this.bearing)+"#"+String.valueOf(this.distance)+"#"+String.valueOf(this.energy)+"#"+String.valueOf(this.heading)
					+"#"+String.valueOf(this.velocity)+"#"+String.valueOf(this.firePower)+"#"+String.valueOf(this.X)+"#"+String.valueOf(this.Y));
					
		}
	
		/**
		 * update: updates the enemy information
		 * @param ScannedRobotEvent
		 * @return 
		 */	
		public void update (ScannedRobotEvent e)
		{
			this.name = e.getName();
			this.bearing = e.getBearing();
			this.bearingRadians = e.getBearingRadians();
			this.distance = e.getDistance();
			this.energy = e.getEnergy();
			this.heading = e.getHeading();
			this.velocity = e.getVelocity();
			
		}
		
		/**
		 * update: updates the enemy information
		 * @param HitRobotEvent
		 * @return 
		 */	
		public void update (HitRobotEvent e)
		{
			this.name = e.getName();
			this.bearing = e.getBearing();
			this.bearingRadians = e.getBearingRadians();
			this.energy = e.getEnergy();
			this.velocity = 0.0;
			this.heading = 0.0;
			this.distance = 0.0;

		}	
		
		
		/**
		 * update: updates the enemy information
		 * @param HitByBulletEvent
		 * @return 
		 */	
		public void update (HitByBulletEvent e)
		{
			this.name = e.getName();
			this.bearing = e.getBearing();
			this.bearingRadians = e.getBearingRadians();
			this.energy = 0.0; 
			this.velocity = 0.0;
			this.heading = e.getHeading();
			this.distance = 0.0;
			

		}
		


		/**
		 * reset: reset the enemy object information
		 * @param 
		 * @return 
		 */	
		public void reset()
		{
			this.name = "";
			this.bearing = 0.0;
			this.bearingRadians = 0.0;
			this.distance = 0.0;
			this.energy = 0.0;
			this.heading = 0.0;
			this.velocity = 0.0;
			this.firePower = 0.0;
		
		}
		
		
		/**
		 * none: checkes whether an enemy is currently exisiting
		 * @param 
		 * @return boolean indicator
		 */	
		public boolean none()
		{
			if (this.name.equals(""))
				return true;
			else
				return false;
		}
	
		/**
		 * getName: returns the name of the current enemy
		 * @param 
		 * @return String enemy name
		 */	
		public String getName()
		{
			return this.name;
		}
	
		
		/**
		 * getBearing: returns the bearing of the current enemy
		 * @param 
		 * @return double enemy bearing
		 */	
		public double getBearing()
		{
			return this.bearing;
		}
	
		/**
		 * getDistance: returns the distance to the current enemy
		 * @param 
		 * @return double distance
		 */	
		public double getDistance()
		{
			return this.distance;
		}
		
		/**
		 * getEnergy: returns the energy of the current enemy
		 * @param 
		 * @return double energy
		 */	
		public double getEnergy()
		{
			return this.energy;
		}
		
		/**
		 * getHeading: returns the heading of the current enemy
		 * @param 
		 * @return double heading
		 */	
		public double getHeading()
		{
			return this.heading;
		}
	
		/**
		 * getVelocity: returns the velocity of the current enemy
		 * @param 
		 * @return double velocity
		 */	
		public double getVelocity()
		{
			return this.velocity;
		}
	
		/**
		 * getFirePower: returns the fire power of the current enemy
		 * @param 
		 * @return double fire power
		 */	
		public double getFirePower() {
			return this.firePower;
		}
	
		/**
		 * getX: returns X of the current enemy
		 * @param 
		 * @return double X
		 */	
		public double getX() {
			return this.X;
		}
	
		 /**
		 * getY: returns Y of the current enemy
		 * @param 
		 * @return double Y
		 */	
		public double getY() {
			return this.Y;
		}
		
		
		/**
		 * setCoordinates: sets the absolute corrodinates of the enemy
		 * @param TeamRobot
		 * @return 
		 */		
		public void setCoordinates(TeamRobot leader) {

			double enemyBearing = leader.getHeading() + this.bearing;
			// Calculate enemy's position
		    this.X = leader.getX() + this.distance * Math.sin(Math.toRadians(enemyBearing));
			this.Y = leader.getY() + this.distance * Math.cos(Math.toRadians(enemyBearing));
			
		}
	
		/**
		 * setName: sets the name of the current enemy
		 * @param String enemy name
		 * @return
		 */	
		public void setName(String name)
		{
			this.name = name;
		}
	
		
		/**
		 * setBearing: sets the bearing of the current enemy
		 * @param double enemy bearing
		 * @return
		 */	
		public void setBearing(double bearing)
		{
			this.bearing = bearing;
		}
	
		/**
		 * setDistance: sets the distance to the current enemy
		 * @param double distance
		 * @return
		 */	
		public void setDistance(double distance)
		{
			this.distance = distance;
		}
		
		/**
		 * setEnergy: sets the energy of the current enemy
		 * @param double energy
		 * @return 
		 */	
		public void setEnergy(double energy)
		{
			this.energy = energy;
		}
		
		/**
		 * setHeading: sets the heading of the current enemy
		 * @param double heading
		 * @return
		 */	
		public void setHeading(double heading)
		{
			this.heading = heading;
		}
	
		/**
		 * setVelocity: sets the velocity of the current enemy
		 * @param double velocity
		 * @return
		 */	
		public void setVelocity(double velocity)
		{
			this.velocity = velocity;
		}
	
		/**
		 * getFirePower: returns the fire power of the current enemy
		 * @param 
		 * @return double fire power
		 */	
		public void setFirePower(double firePower) {
			this.firePower = firePower;
		}
	
		/**
		 * getX: sets X of the current enemy
		 * @param double x
		 * @return
		 */	
		public void setX(double x) {
			this.X = x;
		}
	
		 /**
		 * setY: sets Y of the current enemy
		 * @param double y
		 * @return
		 */	
		public void setY(double y) {
			this.Y = y;
		}
	

	}
