package ws2006.Team1;

import robocode.*;
import java.awt.Color;

/**
 * Scout - ein Roboter von Team 1 (Martin Hartig, Stefan Zeller, Michael Hock)
 */

public class Scout extends TeamRobot {


    /**
     * Variablen
     */
    double gunTurnAmt; // Kanone drehen
    String trackName = null; // Gerade zu attackierender Feindname
    String lastName = null; // Zuvor attackierter Feind
    int radarScanCount = 0; //Wechsel zwischen fullRadarScanHunter() und quarterRadarScanHunter()
    boolean peek; // Nicht drehen falls ein Feind an dieser Stelle steht
    double moveAmount; // Wieviel soll sich der Panzer bewegen
    double power = 50; //Bei Unterschreitung der "power" wird ein Strategiewechsel vollzogen
    boolean runAway = true; //Wechsel zwischen Hunter- und Supporterstrategie
    boolean movingForward; //Vorwrts fahren
    boolean firstAttack = true; //Kanone drehen wenn Strategie gewecheslt wurde


    /**
     * run: Scout's Startmethode
     */

    public void run() {

        while (runAway) { //Solange runAway=true wird die Verteidigungsstrategie gefahren

            moveSupporter(); //Fortbewegung

        }

        while (true) { //Sobald runAway=false wird die Crazy-Strategie gefahren

            if (firstAttack) { //Zwischen den Startegiewechseln wird die Kanon um 90 gedreht
                turnGunLeft(90);
                firstAttack = false; //Kein weiteres Drehen der Kanone mglich
            }

            // Eine groe Zahl vorwrts setzen und warten bis waitFor() die Methode ausfhrt
            setAhead(40000);
            movingForward = true;
            // 90 setzen und rechts drehen sobald waitFor() die Methode ausfhrt
            setTurnRight(90);

            // waitFor startet die Aktionen vorwrts und rechts drehen.
            // waitFor wird beendet sobald der Turn abgeschlossen ist
            waitFor(new TurnCompleteCondition(this));
            //Drehen in die andere Richtung
            setTurnLeft(180);
            // ... solange warten bis Drehung erfolgt ist ...
            waitFor(new TurnCompleteCondition(this));
            // ... nun wieder in die andere Richtung ...
            setTurnRight(180);
            // ... solange warten bis Drehung erfolgt ist
            waitFor(new TurnCompleteCondition(this));
            // Manueller Scan
            scan();
            //...diese Bewegungsstrategie stndig wiederholen (Endlosschleife)
        }

    }

    /**
     * Fortbewegung whrend der Verteidigungsstrategie
     */

    public void moveSupporter() {
        // Initialisiere Schlachtfeldgre
        moveAmount = Math.max(getBattleFieldWidth(), getBattleFieldHeight());
        // Initialisiere peek=false
        peek = false;

        // Zur Wand drehen und an der Wand entlang fahren
        turnLeft(getHeading() % 90);
        ahead(moveAmount);

        // Kanone um 90 nach rechts drehen
        peek = true;
        turnGunRight(90);
        turnRight(90);

        while (runAway) { //stndig wiederholen solange Verteidigungsstrategie gefahren wird
            //Scanne und berprfe ob ein Gegener im Weg steht
            peek = true;
            // An der Wand entlang fahren
            ahead(moveAmount);
            // Nicht mehr scannen
            peek = false;
            // Zur nchsten Wand drehen
            turnRight(90);
        }
    }


    /**
     * Wird eine feindlicher Roboter in der Verteidigungsstrategie gescannt, soll geschossen werden
     * @param e ScannedRobotEvent
     */
    public void onScannedRobot(ScannedRobotEvent e) {
        if (isTeammate(e.getName())) { //Nicht auf Teamkollegen schieen
            return;
        }

        fire(2);

        if (peek) { ////falls kein Feind an dieser Stelle steht
            scan(); //manueller Scan
        }
    }

    /**
     * Reagiere auf Kollisionen
     * @param e HitRobotEvent
     */
    public void onHitRobot(HitRobotEvent e) {
        if (runAway) { //Verteidigungsstrategie
            onHitRobotSupporter(e);
        } else { //Angriff
            onHitRobotCrazy(e);
        }
    }

    /**
     * Bei Kollision in der Verteidigungsstartegie
     * @param e HitRobotEvent
     */

    public void onHitRobotSupporter(HitRobotEvent e) {
        // Wenn Panzer vor uns, fahre ein Stck zurck
        if (e.getBearing() > -90 && e.getBearing() < 90) {
            back(100);
        } else { // falls er hinter uns steht, fahre ein Stck vorwrts
            ahead(100);
        }
    }


    /**
     * Nach einer Kollision mit einem Roboter weicht der Scout aus
     */
    public void onHitRobotCrazy(HitRobotEvent e) {
        // Wenn mit einem anderen Roboter kollidiert wird, fahre zurck
        if (!runAway) {
            if (e.isMyFault()) {
                reverseDirection(); //Fahre vor- oder rckwrts
            }
        }
    }


    /**
     * Reaktion auf Wandkollision
     */

	public void onHitWall(HitWallEvent e) {
		
		if(!runAway){//Wenn Crazystrategie
			reverseDirection();
		}
	}

    /**
     * Fahre vor- oder rckwrts
     */
    public void reverseDirection() {
        if (movingForward) { //wenn Scout nicht mehr vorwrts fahren kann
            setBack(300); //fahre zurck
            movingForward = false; //Scout kann wieder vorwrts fahren
	        } else { //wenn Scout nicht mehr rckwrts fahren kann
            setAhead(300); //fahre vor
            movingForward = true; //Scout kann wieder rckwrts fahren
			
        }
    }


    /**
     * Auf Nachrichten von Teamkollegen reagieren
     * @param event MessageEvent
     */
    public void onMessageReceived(MessageEvent event) {

        //Wenn Scout eine Nachricht vom Terminator erhlt ndert er seine Strategie
        String getSender = event.getSender(); //berprfe den Sender
        if (getSender.equals("t1.Terminator")) { //Wenn Sender Teamkollege ist....
            if (event.getMessage() instanceof Message) { //...und die Nachricht vom Typ 'Message'
                Message m = (Message) event.getMessage(); //...dann speichere Nachricht

                if (m.getMessage().equals("changeStrategy")) { //Wenn Nachricht fr Startegiewechesl erfolgt...
                    runAway = false; //...dann ndere Strategie
                }

            }

        }

    }
}


